<?php

namespace QCC\CampusM\CloudService\EnumType;

/**
 * This class stands for YesNo EnumType
 * @subpackage Enumerations
 */
class YesNo
{
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'y'
     * @return string 'y'
     */
    const VALUE_Y_1 = 'y';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Constant for value 'n'
     * @return string 'n'
     */
    const VALUE_N_1 = 'n';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_Y
     * @uses self::VALUE_Y_1
     * @uses self::VALUE_N
     * @uses self::VALUE_N_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_Y,
            self::VALUE_Y_1,
            self::VALUE_N,
            self::VALUE_N_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
