<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webUIToolBar StructType
 * @subpackage Structs
 */
class WebUIToolBar extends AbstractStructBase
{
    /**
     * The toolBar
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ToolBar[]
     */
    public $toolBar;
    /**
     * Constructor method for webUIToolBar
     * @uses WebUIToolBar::setToolBar()
     * @param \QCC\CampusM\CloudService\StructType\ToolBar[] $toolBar
     */
    public function __construct(array $toolBar = array())
    {
        $this
            ->setToolBar($toolBar);
    }
    /**
     * Get toolBar value
     * @return \QCC\CampusM\CloudService\StructType\ToolBar[]|null
     */
    public function getToolBar()
    {
        return $this->toolBar;
    }
    /**
     * Set toolBar value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\ToolBar[] $toolBar
     * @return \QCC\CampusM\CloudService\StructType\WebUIToolBar
     */
    public function setToolBar(array $toolBar = array())
    {
        foreach ($toolBar as $webUIToolBarToolBarItem) {
            // validation for constraint: itemType
            if (!$webUIToolBarToolBarItem instanceof \QCC\CampusM\CloudService\StructType\ToolBar) {
                throw new \InvalidArgumentException(sprintf('The toolBar property can only contain items of \QCC\CampusM\CloudService\StructType\ToolBar, "%s" given', is_object($webUIToolBarToolBarItem) ? get_class($webUIToolBarToolBarItem) : gettype($webUIToolBarToolBarItem)), __LINE__);
            }
        }
        $this->toolBar = $toolBar;
        return $this;
    }
    /**
     * Add item to toolBar value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\ToolBar $item
     * @return \QCC\CampusM\CloudService\StructType\WebUIToolBar
     */
    public function addToToolBar(\QCC\CampusM\CloudService\StructType\ToolBar $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\ToolBar) {
            throw new \InvalidArgumentException(sprintf('The toolBar property can only contain items of \QCC\CampusM\CloudService\StructType\ToolBar, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->toolBar[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\WebUIToolBar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
