<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for voteCsvRequest StructType
 * @subpackage Structs
 */
class VoteCsvRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgServicePassword
     * @var string
     */
    public $orgServicePassword;
    /**
     * The emailAddress
     * @var string
     */
    public $emailAddress;
    /**
     * The minVoteCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minVoteCode;
    /**
     * The maxVoteCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxVoteCode;
    /**
     * Constructor method for voteCsvRequest
     * @uses VoteCsvRequest::setOrgCode()
     * @uses VoteCsvRequest::setOrgServicePassword()
     * @uses VoteCsvRequest::setEmailAddress()
     * @uses VoteCsvRequest::setMinVoteCode()
     * @uses VoteCsvRequest::setMaxVoteCode()
     * @param int $orgCode
     * @param string $orgServicePassword
     * @param string $emailAddress
     * @param int $minVoteCode
     * @param int $maxVoteCode
     */
    public function __construct($orgCode = null, $orgServicePassword = null, $emailAddress = null, $minVoteCode = null, $maxVoteCode = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgServicePassword($orgServicePassword)
            ->setEmailAddress($emailAddress)
            ->setMinVoteCode($minVoteCode)
            ->setMaxVoteCode($maxVoteCode);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgServicePassword value
     * @return string|null
     */
    public function getOrgServicePassword()
    {
        return $this->orgServicePassword;
    }
    /**
     * Set orgServicePassword value
     * @param string $orgServicePassword
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvRequest
     */
    public function setOrgServicePassword($orgServicePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgServicePassword) && !is_string($orgServicePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgServicePassword)), __LINE__);
        }
        $this->orgServicePassword = $orgServicePassword;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get minVoteCode value
     * @return int|null
     */
    public function getMinVoteCode()
    {
        return $this->minVoteCode;
    }
    /**
     * Set minVoteCode value
     * @param int $minVoteCode
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvRequest
     */
    public function setMinVoteCode($minVoteCode = null)
    {
        // validation for constraint: int
        if (!is_null($minVoteCode) && !is_numeric($minVoteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minVoteCode)), __LINE__);
        }
        $this->minVoteCode = $minVoteCode;
        return $this;
    }
    /**
     * Get maxVoteCode value
     * @return int|null
     */
    public function getMaxVoteCode()
    {
        return $this->maxVoteCode;
    }
    /**
     * Set maxVoteCode value
     * @param int $maxVoteCode
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvRequest
     */
    public function setMaxVoteCode($maxVoteCode = null)
    {
        // validation for constraint: int
        if (!is_null($maxVoteCode) && !is_numeric($maxVoteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxVoteCode)), __LINE__);
        }
        $this->maxVoteCode = $maxVoteCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
