<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vacancyList StructType
 * @subpackage Structs
 */
class VacancyList extends AbstractStructBase
{
    /**
     * The vacancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Vacancy[]
     */
    public $vacancy;
    /**
     * Constructor method for vacancyList
     * @uses VacancyList::setVacancy()
     * @param \QCC\CampusM\CloudService\StructType\Vacancy[] $vacancy
     */
    public function __construct(array $vacancy = array())
    {
        $this
            ->setVacancy($vacancy);
    }
    /**
     * Get vacancy value
     * @return \QCC\CampusM\CloudService\StructType\Vacancy[]|null
     */
    public function getVacancy()
    {
        return $this->vacancy;
    }
    /**
     * Set vacancy value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Vacancy[] $vacancy
     * @return \QCC\CampusM\CloudService\StructType\VacancyList
     */
    public function setVacancy(array $vacancy = array())
    {
        foreach ($vacancy as $vacancyListVacancyItem) {
            // validation for constraint: itemType
            if (!$vacancyListVacancyItem instanceof \QCC\CampusM\CloudService\StructType\Vacancy) {
                throw new \InvalidArgumentException(sprintf('The vacancy property can only contain items of \QCC\CampusM\CloudService\StructType\Vacancy, "%s" given', is_object($vacancyListVacancyItem) ? get_class($vacancyListVacancyItem) : gettype($vacancyListVacancyItem)), __LINE__);
            }
        }
        $this->vacancy = $vacancy;
        return $this;
    }
    /**
     * Add item to vacancy value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Vacancy $item
     * @return \QCC\CampusM\CloudService\StructType\VacancyList
     */
    public function addToVacancy(\QCC\CampusM\CloudService\StructType\Vacancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Vacancy) {
            throw new \InvalidArgumentException(sprintf('The vacancy property can only contain items of \QCC\CampusM\CloudService\StructType\Vacancy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vacancy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\VacancyList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
