<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userLoginRequest StructType
 * @subpackage Structs
 */
class UserLoginRequest extends AbstractStructBase
{
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personId;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * Constructor method for userLoginRequest
     * @uses UserLoginRequest::setPersonId()
     * @uses UserLoginRequest::setEmailAddress()
     * @uses UserLoginRequest::setPassword()
     * @uses UserLoginRequest::setOrgCode()
     * @param int $personId
     * @param string $emailAddress
     * @param string $password
     * @param int $orgCode
     */
    public function __construct($personId = null, $emailAddress = null, $password = null, $orgCode = null)
    {
        $this
            ->setPersonId($personId)
            ->setEmailAddress($emailAddress)
            ->setPassword($password)
            ->setOrgCode($orgCode);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UserLoginRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\UserLoginRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UserLoginRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\UserLoginRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UserLoginRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
