<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateUserDetailRequest StructType
 * @subpackage Structs
 */
class UpdateUserDetailRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The house_no
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $house_no;
    /**
     * Constructor method for updateUserDetailRequest
     * @uses UpdateUserDetailRequest::setPersonId()
     * @uses UpdateUserDetailRequest::setPassword()
     * @uses UpdateUserDetailRequest::setPostcode()
     * @uses UpdateUserDetailRequest::setHouse_no()
     * @param int $personId
     * @param string $password
     * @param string $postcode
     * @param string $house_no
     */
    public function __construct($personId = null, $password = null, $postcode = null, $house_no = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setPostcode($postcode)
            ->setHouse_no($house_no);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get house_no value
     * @return string|null
     */
    public function getHouse_no()
    {
        return $this->house_no;
    }
    /**
     * Set house_no value
     * @param string $house_no
     * @return \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest
     */
    public function setHouse_no($house_no = null)
    {
        // validation for constraint: string
        if (!is_null($house_no) && !is_string($house_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($house_no)), __LINE__);
        }
        $this->house_no = $house_no;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
