<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updatePerson StructType
 * @subpackage Structs
 */
class UpdatePerson extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The currentPassword
     * @var string
     */
    public $currentPassword;
    /**
     * The newPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newPassword;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The photo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $photo;
    /**
     * The telNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telNo;
    /**
     * The emailAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\EmailAddresses
     */
    public $emailAddresses;
    /**
     * The optOut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $optOut;
    /**
     * Constructor method for updatePerson
     * @uses UpdatePerson::setPersonId()
     * @uses UpdatePerson::setCurrentPassword()
     * @uses UpdatePerson::setNewPassword()
     * @uses UpdatePerson::setEmailAddress()
     * @uses UpdatePerson::setFirstName()
     * @uses UpdatePerson::setSurname()
     * @uses UpdatePerson::setPhoto()
     * @uses UpdatePerson::setTelNo()
     * @uses UpdatePerson::setEmailAddresses()
     * @uses UpdatePerson::setOptOut()
     * @param int $personId
     * @param string $currentPassword
     * @param string $newPassword
     * @param string $emailAddress
     * @param string $firstName
     * @param string $surname
     * @param string $photo
     * @param string $telNo
     * @param \QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses
     * @param string $optOut
     */
    public function __construct($personId = null, $currentPassword = null, $newPassword = null, $emailAddress = null, $firstName = null, $surname = null, $photo = null, $telNo = null, \QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses = null, $optOut = null)
    {
        $this
            ->setPersonId($personId)
            ->setCurrentPassword($currentPassword)
            ->setNewPassword($newPassword)
            ->setEmailAddress($emailAddress)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setPhoto($photo)
            ->setTelNo($telNo)
            ->setEmailAddresses($emailAddresses)
            ->setOptOut($optOut);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get currentPassword value
     * @return string|null
     */
    public function getCurrentPassword()
    {
        return $this->currentPassword;
    }
    /**
     * Set currentPassword value
     * @param string $currentPassword
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setCurrentPassword($currentPassword = null)
    {
        // validation for constraint: string
        if (!is_null($currentPassword) && !is_string($currentPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentPassword)), __LINE__);
        }
        $this->currentPassword = $currentPassword;
        return $this;
    }
    /**
     * Get newPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->newPassword;
    }
    /**
     * Set newPassword value
     * @param string $newPassword
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPassword)), __LINE__);
        }
        $this->newPassword = $newPassword;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get photo value
     * @return string|null
     */
    public function getPhoto()
    {
        return $this->photo;
    }
    /**
     * Set photo value
     * @param string $photo
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setPhoto($photo = null)
    {
        // validation for constraint: string
        if (!is_null($photo) && !is_string($photo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($photo)), __LINE__);
        }
        $this->photo = $photo;
        return $this;
    }
    /**
     * Get telNo value
     * @return string|null
     */
    public function getTelNo()
    {
        return $this->telNo;
    }
    /**
     * Set telNo value
     * @param string $telNo
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setTelNo($telNo = null)
    {
        // validation for constraint: string
        if (!is_null($telNo) && !is_string($telNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telNo)), __LINE__);
        }
        $this->telNo = $telNo;
        return $this;
    }
    /**
     * Get emailAddresses value
     * @return \QCC\CampusM\CloudService\StructType\EmailAddresses|null
     */
    public function getEmailAddresses()
    {
        return $this->emailAddresses;
    }
    /**
     * Set emailAddresses value
     * @param \QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setEmailAddresses(\QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses = null)
    {
        $this->emailAddresses = $emailAddresses;
        return $this;
    }
    /**
     * Get optOut value
     * @return string|null
     */
    public function getOptOut()
    {
        return $this->optOut;
    }
    /**
     * Set optOut value
     * @param string $optOut
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public function setOptOut($optOut = null)
    {
        // validation for constraint: string
        if (!is_null($optOut) && !is_string($optOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optOut)), __LINE__);
        }
        $this->optOut = $optOut;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UpdatePerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
