<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateFeedsDataRequest StructType
 * @subpackage Structs
 */
class UpdateFeedsDataRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * The isCallFeeds
     * Meta informations extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $isCallFeeds;
    /**
     * The isUpdatePG
     * Meta informations extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $isUpdatePG;
    /**
     * The isUpdateSurveys
     * Meta informations extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $isUpdateSurveys;
    /**
     * The isUpdateLocations
     * Meta informations extracted from the WSDL
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $isUpdateLocations;
    /**
     * Constructor method for updateFeedsDataRequest
     * @uses UpdateFeedsDataRequest::setOrgCode()
     * @uses UpdateFeedsDataRequest::setPassword()
     * @uses UpdateFeedsDataRequest::setProfileId()
     * @uses UpdateFeedsDataRequest::setIsCallFeeds()
     * @uses UpdateFeedsDataRequest::setIsUpdatePG()
     * @uses UpdateFeedsDataRequest::setIsUpdateSurveys()
     * @uses UpdateFeedsDataRequest::setIsUpdateLocations()
     * @param int $orgCode
     * @param string $password
     * @param int $profileId
     * @param bool $isCallFeeds
     * @param bool $isUpdatePG
     * @param bool $isUpdateSurveys
     * @param bool $isUpdateLocations
     */
    public function __construct($orgCode = null, $password = null, $profileId = null, $isCallFeeds = true, $isUpdatePG = true, $isUpdateSurveys = true, $isUpdateLocations = false)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setProfileId($profileId)
            ->setIsCallFeeds($isCallFeeds)
            ->setIsUpdatePG($isUpdatePG)
            ->setIsUpdateSurveys($isUpdateSurveys)
            ->setIsUpdateLocations($isUpdateLocations);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get isCallFeeds value
     * @return bool|null
     */
    public function getIsCallFeeds()
    {
        return $this->isCallFeeds;
    }
    /**
     * Set isCallFeeds value
     * @param bool $isCallFeeds
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setIsCallFeeds($isCallFeeds = true)
    {
        // validation for constraint: boolean
        if (!is_null($isCallFeeds) && !is_bool($isCallFeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCallFeeds)), __LINE__);
        }
        $this->isCallFeeds = $isCallFeeds;
        return $this;
    }
    /**
     * Get isUpdatePG value
     * @return bool|null
     */
    public function getIsUpdatePG()
    {
        return $this->isUpdatePG;
    }
    /**
     * Set isUpdatePG value
     * @param bool $isUpdatePG
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setIsUpdatePG($isUpdatePG = true)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatePG) && !is_bool($isUpdatePG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdatePG)), __LINE__);
        }
        $this->isUpdatePG = $isUpdatePG;
        return $this;
    }
    /**
     * Get isUpdateSurveys value
     * @return bool|null
     */
    public function getIsUpdateSurveys()
    {
        return $this->isUpdateSurveys;
    }
    /**
     * Set isUpdateSurveys value
     * @param bool $isUpdateSurveys
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setIsUpdateSurveys($isUpdateSurveys = true)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSurveys) && !is_bool($isUpdateSurveys)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdateSurveys)), __LINE__);
        }
        $this->isUpdateSurveys = $isUpdateSurveys;
        return $this;
    }
    /**
     * Get isUpdateLocations value
     * @return bool|null
     */
    public function getIsUpdateLocations()
    {
        return $this->isUpdateLocations;
    }
    /**
     * Set isUpdateLocations value
     * @param bool $isUpdateLocations
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public function setIsUpdateLocations($isUpdateLocations = false)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateLocations) && !is_bool($isUpdateLocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdateLocations)), __LINE__);
        }
        $this->isUpdateLocations = $isUpdateLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
