<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateDistanceSettingRequest StructType
 * @subpackage Structs
 */
class UpdateDistanceSettingRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * The setting
     * @var string
     */
    public $setting;
    /**
     * Constructor method for updateDistanceSettingRequest
     * @uses UpdateDistanceSettingRequest::setPersonId()
     * @uses UpdateDistanceSettingRequest::setPassword()
     * @uses UpdateDistanceSettingRequest::setProfileId()
     * @uses UpdateDistanceSettingRequest::setSetting()
     * @param int $personId
     * @param string $password
     * @param int $profileId
     * @param string $setting
     */
    public function __construct($personId = null, $password = null, $profileId = null, $setting = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setProfileId($profileId)
            ->setSetting($setting);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get setting value
     * @return string|null
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @param string $setting
     * @return \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest
     */
    public function setSetting($setting = null)
    {
        // validation for constraint: string
        if (!is_null($setting) && !is_string($setting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($setting)), __LINE__);
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
