<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for titem StructType
 * @subpackage Structs
 */
class Titem extends AbstractStructBase
{
    /**
     * The objName
     * @var string
     */
    public $objName;
    /**
     * The objValue
     * @var int
     */
    public $objValue;
    /**
     * Constructor method for titem
     * @uses Titem::setObjName()
     * @uses Titem::setObjValue()
     * @param string $objName
     * @param int $objValue
     */
    public function __construct($objName = null, $objValue = null)
    {
        $this
            ->setObjName($objName)
            ->setObjValue($objValue);
    }
    /**
     * Get objName value
     * @return string|null
     */
    public function getObjName()
    {
        return $this->objName;
    }
    /**
     * Set objName value
     * @param string $objName
     * @return \QCC\CampusM\CloudService\StructType\Titem
     */
    public function setObjName($objName = null)
    {
        // validation for constraint: string
        if (!is_null($objName) && !is_string($objName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objName)), __LINE__);
        }
        $this->objName = $objName;
        return $this;
    }
    /**
     * Get objValue value
     * @return int|null
     */
    public function getObjValue()
    {
        return $this->objValue;
    }
    /**
     * Set objValue value
     * @param int $objValue
     * @return \QCC\CampusM\CloudService\StructType\Titem
     */
    public function setObjValue($objValue = null)
    {
        // validation for constraint: int
        if (!is_null($objValue) && !is_numeric($objValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($objValue)), __LINE__);
        }
        $this->objValue = $objValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Titem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
