<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for suggestionsMenuCode StructType
 * @subpackage Structs
 */
class SuggestionsMenuCode extends AbstractStructBase
{
    /**
     * The menuCode
     * @var int
     */
    public $menuCode;
    /**
     * The suggestions
     * @var \QCC\CampusM\CloudService\StructType\Suggestions
     */
    public $suggestions;
    /**
     * Constructor method for suggestionsMenuCode
     * @uses SuggestionsMenuCode::setMenuCode()
     * @uses SuggestionsMenuCode::setSuggestions()
     * @param int $menuCode
     * @param \QCC\CampusM\CloudService\StructType\Suggestions $suggestions
     */
    public function __construct($menuCode = null, \QCC\CampusM\CloudService\StructType\Suggestions $suggestions = null)
    {
        $this
            ->setMenuCode($menuCode)
            ->setSuggestions($suggestions);
    }
    /**
     * Get menuCode value
     * @return int|null
     */
    public function getMenuCode()
    {
        return $this->menuCode;
    }
    /**
     * Set menuCode value
     * @param int $menuCode
     * @return \QCC\CampusM\CloudService\StructType\SuggestionsMenuCode
     */
    public function setMenuCode($menuCode = null)
    {
        // validation for constraint: int
        if (!is_null($menuCode) && !is_numeric($menuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($menuCode)), __LINE__);
        }
        $this->menuCode = $menuCode;
        return $this;
    }
    /**
     * Get suggestions value
     * @return \QCC\CampusM\CloudService\StructType\Suggestions|null
     */
    public function getSuggestions()
    {
        return $this->suggestions;
    }
    /**
     * Set suggestions value
     * @param \QCC\CampusM\CloudService\StructType\Suggestions $suggestions
     * @return \QCC\CampusM\CloudService\StructType\SuggestionsMenuCode
     */
    public function setSuggestions(\QCC\CampusM\CloudService\StructType\Suggestions $suggestions = null)
    {
        $this->suggestions = $suggestions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SuggestionsMenuCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
