<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setupUserResponse StructType
 * @subpackage Structs
 */
class SetupUserResponse extends AbstractStructBase
{
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userType;
    /**
     * The newUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newUser;
    /**
     * The generatedEmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $generatedEmailAddress;
    /**
     * The profileRoleLists
     * @var \QCC\CampusM\CloudService\StructType\ProfileRoleLists
     */
    public $profileRoleLists;
    /**
     * Constructor method for setupUserResponse
     * @uses SetupUserResponse::setPersonId()
     * @uses SetupUserResponse::setPassword()
     * @uses SetupUserResponse::setUserType()
     * @uses SetupUserResponse::setNewUser()
     * @uses SetupUserResponse::setGeneratedEmailAddress()
     * @uses SetupUserResponse::setProfileRoleLists()
     * @param int $personId
     * @param string $password
     * @param string $userType
     * @param string $newUser
     * @param string $generatedEmailAddress
     * @param \QCC\CampusM\CloudService\StructType\ProfileRoleLists $profileRoleLists
     */
    public function __construct($personId = null, $password = null, $userType = null, $newUser = null, $generatedEmailAddress = null, \QCC\CampusM\CloudService\StructType\ProfileRoleLists $profileRoleLists = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setUserType($userType)
            ->setNewUser($newUser)
            ->setGeneratedEmailAddress($generatedEmailAddress)
            ->setProfileRoleLists($profileRoleLists);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get userType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->userType;
    }
    /**
     * Set userType value
     * @param string $userType
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userType)), __LINE__);
        }
        $this->userType = $userType;
        return $this;
    }
    /**
     * Get newUser value
     * @return string|null
     */
    public function getNewUser()
    {
        return $this->newUser;
    }
    /**
     * Set newUser value
     * @param string $newUser
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function setNewUser($newUser = null)
    {
        // validation for constraint: string
        if (!is_null($newUser) && !is_string($newUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newUser)), __LINE__);
        }
        $this->newUser = $newUser;
        return $this;
    }
    /**
     * Get generatedEmailAddress value
     * @return string|null
     */
    public function getGeneratedEmailAddress()
    {
        return $this->generatedEmailAddress;
    }
    /**
     * Set generatedEmailAddress value
     * @param string $generatedEmailAddress
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function setGeneratedEmailAddress($generatedEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($generatedEmailAddress) && !is_string($generatedEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generatedEmailAddress)), __LINE__);
        }
        $this->generatedEmailAddress = $generatedEmailAddress;
        return $this;
    }
    /**
     * Get profileRoleLists value
     * @return \QCC\CampusM\CloudService\StructType\ProfileRoleLists|null
     */
    public function getProfileRoleLists()
    {
        return $this->profileRoleLists;
    }
    /**
     * Set profileRoleLists value
     * @param \QCC\CampusM\CloudService\StructType\ProfileRoleLists $profileRoleLists
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function setProfileRoleLists(\QCC\CampusM\CloudService\StructType\ProfileRoleLists $profileRoleLists = null)
    {
        $this->profileRoleLists = $profileRoleLists;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
