<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setRolesUpdatedRequest StructType
 * @subpackage Structs
 */
class SetRolesUpdatedRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The emails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Emails
     */
    public $emails;
    /**
     * The updateAllUsers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $updateAllUsers;
    /**
     * Constructor method for setRolesUpdatedRequest
     * @uses SetRolesUpdatedRequest::setOrgCode()
     * @uses SetRolesUpdatedRequest::setPassword()
     * @uses SetRolesUpdatedRequest::setEmails()
     * @uses SetRolesUpdatedRequest::setUpdateAllUsers()
     * @param int $orgCode
     * @param string $password
     * @param \QCC\CampusM\CloudService\StructType\Emails $emails
     * @param bool $updateAllUsers
     */
    public function __construct($orgCode = null, $password = null, \QCC\CampusM\CloudService\StructType\Emails $emails = null, $updateAllUsers = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setEmails($emails)
            ->setUpdateAllUsers($updateAllUsers);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SetRolesUpdatedRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SetRolesUpdatedRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get emails value
     * @return \QCC\CampusM\CloudService\StructType\Emails|null
     */
    public function getEmails()
    {
        return $this->emails;
    }
    /**
     * Set emails value
     * @param \QCC\CampusM\CloudService\StructType\Emails $emails
     * @return \QCC\CampusM\CloudService\StructType\SetRolesUpdatedRequest
     */
    public function setEmails(\QCC\CampusM\CloudService\StructType\Emails $emails = null)
    {
        $this->emails = $emails;
        return $this;
    }
    /**
     * Get updateAllUsers value
     * @return bool|null
     */
    public function getUpdateAllUsers()
    {
        return $this->updateAllUsers;
    }
    /**
     * Set updateAllUsers value
     * @param bool $updateAllUsers
     * @return \QCC\CampusM\CloudService\StructType\SetRolesUpdatedRequest
     */
    public function setUpdateAllUsers($updateAllUsers = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateAllUsers) && !is_bool($updateAllUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($updateAllUsers)), __LINE__);
        }
        $this->updateAllUsers = $updateAllUsers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SetRolesUpdatedRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
