<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setAppServerPasswordRequest StructType
 * @subpackage Structs
 */
class SetAppServerPasswordRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The appServerId
     * @var int
     */
    public $appServerId;
    /**
     * The newPassword
     * @var string
     */
    public $newPassword;
    /**
     * Constructor method for setAppServerPasswordRequest
     * @uses SetAppServerPasswordRequest::setOrgCode()
     * @uses SetAppServerPasswordRequest::setPassword()
     * @uses SetAppServerPasswordRequest::setAppServerId()
     * @uses SetAppServerPasswordRequest::setNewPassword()
     * @param int $orgCode
     * @param string $password
     * @param int $appServerId
     * @param string $newPassword
     */
    public function __construct($orgCode = null, $password = null, $appServerId = null, $newPassword = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setAppServerId($appServerId)
            ->setNewPassword($newPassword);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SetAppServerPasswordRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SetAppServerPasswordRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get appServerId value
     * @return int|null
     */
    public function getAppServerId()
    {
        return $this->appServerId;
    }
    /**
     * Set appServerId value
     * @param int $appServerId
     * @return \QCC\CampusM\CloudService\StructType\SetAppServerPasswordRequest
     */
    public function setAppServerId($appServerId = null)
    {
        // validation for constraint: int
        if (!is_null($appServerId) && !is_numeric($appServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appServerId)), __LINE__);
        }
        $this->appServerId = $appServerId;
        return $this;
    }
    /**
     * Get newPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->newPassword;
    }
    /**
     * Set newPassword value
     * @param string $newPassword
     * @return \QCC\CampusM\CloudService\StructType\SetAppServerPasswordRequest
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPassword)), __LINE__);
        }
        $this->newPassword = $newPassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SetAppServerPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
