<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendRssAlerts StructType
 * @subpackage Structs
 */
class SendRssAlerts extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgServicePassword
     * @var string
     */
    public $orgServicePassword;
    /**
     * The rssUrl
     * @var string
     */
    public $rssUrl;
    /**
     * The uniqueIdRssField
     * @var string
     */
    public $uniqueIdRssField;
    /**
     * The alertPreferencesType
     * @var string
     */
    public $alertPreferencesType;
    /**
     * The alertPreferencesComponent
     * @var string
     */
    public $alertPreferencesComponent;
    /**
     * The alertPreferencesReference
     * @var string
     */
    public $alertPreferencesReference;
    /**
     * The setupHistoryOnly
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $setupHistoryOnly;
    /**
     * Constructor method for sendRssAlerts
     * @uses SendRssAlerts::setOrgCode()
     * @uses SendRssAlerts::setOrgServicePassword()
     * @uses SendRssAlerts::setRssUrl()
     * @uses SendRssAlerts::setUniqueIdRssField()
     * @uses SendRssAlerts::setAlertPreferencesType()
     * @uses SendRssAlerts::setAlertPreferencesComponent()
     * @uses SendRssAlerts::setAlertPreferencesReference()
     * @uses SendRssAlerts::setSetupHistoryOnly()
     * @param int $orgCode
     * @param string $orgServicePassword
     * @param string $rssUrl
     * @param string $uniqueIdRssField
     * @param string $alertPreferencesType
     * @param string $alertPreferencesComponent
     * @param string $alertPreferencesReference
     * @param bool $setupHistoryOnly
     */
    public function __construct($orgCode = null, $orgServicePassword = null, $rssUrl = null, $uniqueIdRssField = null, $alertPreferencesType = null, $alertPreferencesComponent = null, $alertPreferencesReference = null, $setupHistoryOnly = false)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgServicePassword($orgServicePassword)
            ->setRssUrl($rssUrl)
            ->setUniqueIdRssField($uniqueIdRssField)
            ->setAlertPreferencesType($alertPreferencesType)
            ->setAlertPreferencesComponent($alertPreferencesComponent)
            ->setAlertPreferencesReference($alertPreferencesReference)
            ->setSetupHistoryOnly($setupHistoryOnly);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgServicePassword value
     * @return string|null
     */
    public function getOrgServicePassword()
    {
        return $this->orgServicePassword;
    }
    /**
     * Set orgServicePassword value
     * @param string $orgServicePassword
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setOrgServicePassword($orgServicePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgServicePassword) && !is_string($orgServicePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgServicePassword)), __LINE__);
        }
        $this->orgServicePassword = $orgServicePassword;
        return $this;
    }
    /**
     * Get rssUrl value
     * @return string|null
     */
    public function getRssUrl()
    {
        return $this->rssUrl;
    }
    /**
     * Set rssUrl value
     * @param string $rssUrl
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setRssUrl($rssUrl = null)
    {
        // validation for constraint: string
        if (!is_null($rssUrl) && !is_string($rssUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rssUrl)), __LINE__);
        }
        $this->rssUrl = $rssUrl;
        return $this;
    }
    /**
     * Get uniqueIdRssField value
     * @return string|null
     */
    public function getUniqueIdRssField()
    {
        return $this->uniqueIdRssField;
    }
    /**
     * Set uniqueIdRssField value
     * @param string $uniqueIdRssField
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setUniqueIdRssField($uniqueIdRssField = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueIdRssField) && !is_string($uniqueIdRssField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueIdRssField)), __LINE__);
        }
        $this->uniqueIdRssField = $uniqueIdRssField;
        return $this;
    }
    /**
     * Get alertPreferencesType value
     * @return string|null
     */
    public function getAlertPreferencesType()
    {
        return $this->alertPreferencesType;
    }
    /**
     * Set alertPreferencesType value
     * @param string $alertPreferencesType
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setAlertPreferencesType($alertPreferencesType = null)
    {
        // validation for constraint: string
        if (!is_null($alertPreferencesType) && !is_string($alertPreferencesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertPreferencesType)), __LINE__);
        }
        $this->alertPreferencesType = $alertPreferencesType;
        return $this;
    }
    /**
     * Get alertPreferencesComponent value
     * @return string|null
     */
    public function getAlertPreferencesComponent()
    {
        return $this->alertPreferencesComponent;
    }
    /**
     * Set alertPreferencesComponent value
     * @param string $alertPreferencesComponent
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setAlertPreferencesComponent($alertPreferencesComponent = null)
    {
        // validation for constraint: string
        if (!is_null($alertPreferencesComponent) && !is_string($alertPreferencesComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertPreferencesComponent)), __LINE__);
        }
        $this->alertPreferencesComponent = $alertPreferencesComponent;
        return $this;
    }
    /**
     * Get alertPreferencesReference value
     * @return string|null
     */
    public function getAlertPreferencesReference()
    {
        return $this->alertPreferencesReference;
    }
    /**
     * Set alertPreferencesReference value
     * @param string $alertPreferencesReference
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setAlertPreferencesReference($alertPreferencesReference = null)
    {
        // validation for constraint: string
        if (!is_null($alertPreferencesReference) && !is_string($alertPreferencesReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertPreferencesReference)), __LINE__);
        }
        $this->alertPreferencesReference = $alertPreferencesReference;
        return $this;
    }
    /**
     * Get setupHistoryOnly value
     * @return bool|null
     */
    public function getSetupHistoryOnly()
    {
        return $this->setupHistoryOnly;
    }
    /**
     * Set setupHistoryOnly value
     * @param bool $setupHistoryOnly
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public function setSetupHistoryOnly($setupHistoryOnly = false)
    {
        // validation for constraint: boolean
        if (!is_null($setupHistoryOnly) && !is_bool($setupHistoryOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($setupHistoryOnly)), __LINE__);
        }
        $this->setupHistoryOnly = $setupHistoryOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SendRssAlerts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
