<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendAlertsRequest StructType
 * @subpackage Structs
 */
class SendAlertsRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The notifications
     * @var \QCC\CampusM\CloudService\StructType\Notifications
     */
    public $notifications;
    /**
     * Constructor method for sendAlertsRequest
     * @uses SendAlertsRequest::setOrgCode()
     * @uses SendAlertsRequest::setPassword()
     * @uses SendAlertsRequest::setNotifications()
     * @param int $orgCode
     * @param string $password
     * @param \QCC\CampusM\CloudService\StructType\Notifications $notifications
     */
    public function __construct($orgCode = null, $password = null, \QCC\CampusM\CloudService\StructType\Notifications $notifications = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setNotifications($notifications);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SendAlertsRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SendAlertsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get notifications value
     * @return \QCC\CampusM\CloudService\StructType\Notifications|null
     */
    public function getNotifications()
    {
        return $this->notifications;
    }
    /**
     * Set notifications value
     * @param \QCC\CampusM\CloudService\StructType\Notifications $notifications
     * @return \QCC\CampusM\CloudService\StructType\SendAlertsRequest
     */
    public function setNotifications(\QCC\CampusM\CloudService\StructType\Notifications $notifications = null)
    {
        $this->notifications = $notifications;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SendAlertsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
