<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchPersonRequest StructType
 * @subpackage Structs
 */
class SearchPersonRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The maxList
     * @var int
     */
    public $maxList;
    /**
     * The searchString
     * @var string
     */
    public $searchString;
    /**
     * Constructor method for searchPersonRequest
     * @uses SearchPersonRequest::setPersonId()
     * @uses SearchPersonRequest::setPassword()
     * @uses SearchPersonRequest::setOrgCode()
     * @uses SearchPersonRequest::setMaxList()
     * @uses SearchPersonRequest::setSearchString()
     * @param int $personId
     * @param string $password
     * @param int $orgCode
     * @param int $maxList
     * @param string $searchString
     */
    public function __construct($personId = null, $password = null, $orgCode = null, $maxList = null, $searchString = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setOrgCode($orgCode)
            ->setMaxList($maxList)
            ->setSearchString($searchString);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get maxList value
     * @return int|null
     */
    public function getMaxList()
    {
        return $this->maxList;
    }
    /**
     * Set maxList value
     * @param int $maxList
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonRequest
     */
    public function setMaxList($maxList = null)
    {
        // validation for constraint: int
        if (!is_null($maxList) && !is_numeric($maxList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxList)), __LINE__);
        }
        $this->maxList = $maxList;
        return $this;
    }
    /**
     * Get searchString value
     * @return string|null
     */
    public function getSearchString()
    {
        return $this->searchString;
    }
    /**
     * Set searchString value
     * @param string $searchString
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonRequest
     */
    public function setSearchString($searchString = null)
    {
        // validation for constraint: string
        if (!is_null($searchString) && !is_string($searchString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchString)), __LINE__);
        }
        $this->searchString = $searchString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
