<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removePersonRolesRequest StructType
 * @subpackage Structs
 */
class RemovePersonRolesRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The emailAddress
     * @var string
     */
    public $emailAddress;
    /**
     * The appRoleIds
     * @var \QCC\CampusM\CloudService\StructType\AppRoleIds
     */
    public $appRoleIds;
    /**
     * Constructor method for removePersonRolesRequest
     * @uses RemovePersonRolesRequest::setOrgCode()
     * @uses RemovePersonRolesRequest::setPassword()
     * @uses RemovePersonRolesRequest::setEmailAddress()
     * @uses RemovePersonRolesRequest::setAppRoleIds()
     * @param int $orgCode
     * @param string $password
     * @param string $emailAddress
     * @param \QCC\CampusM\CloudService\StructType\AppRoleIds $appRoleIds
     */
    public function __construct($orgCode = null, $password = null, $emailAddress = null, \QCC\CampusM\CloudService\StructType\AppRoleIds $appRoleIds = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setEmailAddress($emailAddress)
            ->setAppRoleIds($appRoleIds);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\RemovePersonRolesRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\RemovePersonRolesRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\RemovePersonRolesRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get appRoleIds value
     * @return \QCC\CampusM\CloudService\StructType\AppRoleIds|null
     */
    public function getAppRoleIds()
    {
        return $this->appRoleIds;
    }
    /**
     * Set appRoleIds value
     * @param \QCC\CampusM\CloudService\StructType\AppRoleIds $appRoleIds
     * @return \QCC\CampusM\CloudService\StructType\RemovePersonRolesRequest
     */
    public function setAppRoleIds(\QCC\CampusM\CloudService\StructType\AppRoleIds $appRoleIds = null)
    {
        $this->appRoleIds = $appRoleIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\RemovePersonRolesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
