<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for question StructType
 * @subpackage Structs
 */
class Question extends AbstractStructBase
{
    /**
     * The vcCode
     * @var int
     */
    public $vcCode;
    /**
     * The vqCode
     * @var int
     */
    public $vqCode;
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $order;
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $group;
    /**
     * The q
     * @var string
     */
    public $q;
    /**
     * The submittedBy
     * @var string
     */
    public $submittedBy;
    /**
     * The submittedDt
     * @var string
     */
    public $submittedDt;
    /**
     * The expiryDt
     * @var string
     */
    public $expiryDt;
    /**
     * The totalVotes
     * @var int
     */
    public $totalVotes;
    /**
     * The amendVote
     * @var string
     */
    public $amendVote;
    /**
     * The vqType
     * @var string
     */
    public $vqType;
    /**
     * The attempts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $attempts;
    /**
     * The answerType
     * @var string
     */
    public $answerType;
    /**
     * The personVotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\PersonVotes
     */
    public $personVotes;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Options
     */
    public $options;
    /**
     * The grUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $grUrl;
    /**
     * Constructor method for question
     * @uses Question::setVcCode()
     * @uses Question::setVqCode()
     * @uses Question::setOrder()
     * @uses Question::setGroup()
     * @uses Question::setQ()
     * @uses Question::setSubmittedBy()
     * @uses Question::setSubmittedDt()
     * @uses Question::setExpiryDt()
     * @uses Question::setTotalVotes()
     * @uses Question::setAmendVote()
     * @uses Question::setVqType()
     * @uses Question::setAttempts()
     * @uses Question::setAnswerType()
     * @uses Question::setPersonVotes()
     * @uses Question::setOptions()
     * @uses Question::setGrUrl()
     * @param int $vcCode
     * @param int $vqCode
     * @param int $order
     * @param string $group
     * @param string $q
     * @param string $submittedBy
     * @param string $submittedDt
     * @param string $expiryDt
     * @param int $totalVotes
     * @param string $amendVote
     * @param string $vqType
     * @param int $attempts
     * @param string $answerType
     * @param \QCC\CampusM\CloudService\StructType\PersonVotes $personVotes
     * @param \QCC\CampusM\CloudService\StructType\Options $options
     * @param string $grUrl
     */
    public function __construct($vcCode = null, $vqCode = null, $order = null, $group = null, $q = null, $submittedBy = null, $submittedDt = null, $expiryDt = null, $totalVotes = null, $amendVote = null, $vqType = null, $attempts = null, $answerType = null, \QCC\CampusM\CloudService\StructType\PersonVotes $personVotes = null, \QCC\CampusM\CloudService\StructType\Options $options = null, $grUrl = null)
    {
        $this
            ->setVcCode($vcCode)
            ->setVqCode($vqCode)
            ->setOrder($order)
            ->setGroup($group)
            ->setQ($q)
            ->setSubmittedBy($submittedBy)
            ->setSubmittedDt($submittedDt)
            ->setExpiryDt($expiryDt)
            ->setTotalVotes($totalVotes)
            ->setAmendVote($amendVote)
            ->setVqType($vqType)
            ->setAttempts($attempts)
            ->setAnswerType($answerType)
            ->setPersonVotes($personVotes)
            ->setOptions($options)
            ->setGrUrl($grUrl);
    }
    /**
     * Get vcCode value
     * @return int|null
     */
    public function getVcCode()
    {
        return $this->vcCode;
    }
    /**
     * Set vcCode value
     * @param int $vcCode
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setVcCode($vcCode = null)
    {
        // validation for constraint: int
        if (!is_null($vcCode) && !is_numeric($vcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vcCode)), __LINE__);
        }
        $this->vcCode = $vcCode;
        return $this;
    }
    /**
     * Get vqCode value
     * @return int|null
     */
    public function getVqCode()
    {
        return $this->vqCode;
    }
    /**
     * Set vqCode value
     * @param int $vqCode
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setVqCode($vqCode = null)
    {
        // validation for constraint: int
        if (!is_null($vqCode) && !is_numeric($vqCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vqCode)), __LINE__);
        }
        $this->vqCode = $vqCode;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param string $group
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Get q value
     * @return string|null
     */
    public function getQ()
    {
        return $this->q;
    }
    /**
     * Set q value
     * @param string $q
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setQ($q = null)
    {
        // validation for constraint: string
        if (!is_null($q) && !is_string($q)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($q)), __LINE__);
        }
        $this->q = $q;
        return $this;
    }
    /**
     * Get submittedBy value
     * @return string|null
     */
    public function getSubmittedBy()
    {
        return $this->submittedBy;
    }
    /**
     * Set submittedBy value
     * @param string $submittedBy
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setSubmittedBy($submittedBy = null)
    {
        // validation for constraint: string
        if (!is_null($submittedBy) && !is_string($submittedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submittedBy)), __LINE__);
        }
        $this->submittedBy = $submittedBy;
        return $this;
    }
    /**
     * Get submittedDt value
     * @return string|null
     */
    public function getSubmittedDt()
    {
        return $this->submittedDt;
    }
    /**
     * Set submittedDt value
     * @param string $submittedDt
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setSubmittedDt($submittedDt = null)
    {
        // validation for constraint: string
        if (!is_null($submittedDt) && !is_string($submittedDt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submittedDt)), __LINE__);
        }
        $this->submittedDt = $submittedDt;
        return $this;
    }
    /**
     * Get expiryDt value
     * @return string|null
     */
    public function getExpiryDt()
    {
        return $this->expiryDt;
    }
    /**
     * Set expiryDt value
     * @param string $expiryDt
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setExpiryDt($expiryDt = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDt) && !is_string($expiryDt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDt)), __LINE__);
        }
        $this->expiryDt = $expiryDt;
        return $this;
    }
    /**
     * Get totalVotes value
     * @return int|null
     */
    public function getTotalVotes()
    {
        return $this->totalVotes;
    }
    /**
     * Set totalVotes value
     * @param int $totalVotes
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setTotalVotes($totalVotes = null)
    {
        // validation for constraint: int
        if (!is_null($totalVotes) && !is_numeric($totalVotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalVotes)), __LINE__);
        }
        $this->totalVotes = $totalVotes;
        return $this;
    }
    /**
     * Get amendVote value
     * @return string|null
     */
    public function getAmendVote()
    {
        return $this->amendVote;
    }
    /**
     * Set amendVote value
     * @param string $amendVote
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setAmendVote($amendVote = null)
    {
        // validation for constraint: string
        if (!is_null($amendVote) && !is_string($amendVote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amendVote)), __LINE__);
        }
        $this->amendVote = $amendVote;
        return $this;
    }
    /**
     * Get vqType value
     * @return string|null
     */
    public function getVqType()
    {
        return $this->vqType;
    }
    /**
     * Set vqType value
     * @param string $vqType
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setVqType($vqType = null)
    {
        // validation for constraint: string
        if (!is_null($vqType) && !is_string($vqType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vqType)), __LINE__);
        }
        $this->vqType = $vqType;
        return $this;
    }
    /**
     * Get attempts value
     * @return int|null
     */
    public function getAttempts()
    {
        return $this->attempts;
    }
    /**
     * Set attempts value
     * @param int $attempts
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setAttempts($attempts = null)
    {
        // validation for constraint: int
        if (!is_null($attempts) && !is_numeric($attempts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attempts)), __LINE__);
        }
        $this->attempts = $attempts;
        return $this;
    }
    /**
     * Get answerType value
     * @return string|null
     */
    public function getAnswerType()
    {
        return $this->answerType;
    }
    /**
     * Set answerType value
     * @param string $answerType
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setAnswerType($answerType = null)
    {
        // validation for constraint: string
        if (!is_null($answerType) && !is_string($answerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerType)), __LINE__);
        }
        $this->answerType = $answerType;
        return $this;
    }
    /**
     * Get personVotes value
     * @return \QCC\CampusM\CloudService\StructType\PersonVotes|null
     */
    public function getPersonVotes()
    {
        return $this->personVotes;
    }
    /**
     * Set personVotes value
     * @param \QCC\CampusM\CloudService\StructType\PersonVotes $personVotes
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setPersonVotes(\QCC\CampusM\CloudService\StructType\PersonVotes $personVotes = null)
    {
        $this->personVotes = $personVotes;
        return $this;
    }
    /**
     * Get options value
     * @return \QCC\CampusM\CloudService\StructType\Options|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \QCC\CampusM\CloudService\StructType\Options $options
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setOptions(\QCC\CampusM\CloudService\StructType\Options $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get grUrl value
     * @return string|null
     */
    public function getGrUrl()
    {
        return $this->grUrl;
    }
    /**
     * Set grUrl value
     * @param string $grUrl
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public function setGrUrl($grUrl = null)
    {
        // validation for constraint: string
        if (!is_null($grUrl) && !is_string($grUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grUrl)), __LINE__);
        }
        $this->grUrl = $grUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Question
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
