<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pushCentreStatusRequest StructType
 * @subpackage Structs
 */
class PushCentreStatusRequest extends AbstractAdminServiceRequest
{
    /**
     * The orgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orgCode;
    /**
     * The platform
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $platform;
    /**
     * Constructor method for pushCentreStatusRequest
     * @uses PushCentreStatusRequest::setOrgCode()
     * @uses PushCentreStatusRequest::setPlatform()
     * @param int $orgCode
     * @param string $platform
     */
    public function __construct($orgCode = null, $platform = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPlatform($platform);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatusRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatusRequest
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: string
        if (!is_null($platform) && !is_string($platform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($platform)), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
