<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for option StructType
 * @subpackage Structs
 */
class Option extends AbstractStructBase
{
    /**
     * The voCode
     * @var int
     */
    public $voCode;
    /**
     * The desc
     * @var string
     */
    public $desc;
    /**
     * The order
     * @var int
     */
    public $order;
    /**
     * The votes
     * @var int
     */
    public $votes;
    /**
     * The answer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $answer;
    /**
     * The question
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $question;
    /**
     * Constructor method for option
     * @uses Option::setVoCode()
     * @uses Option::setDesc()
     * @uses Option::setOrder()
     * @uses Option::setVotes()
     * @uses Option::setAnswer()
     * @uses Option::setQuestion()
     * @param int $voCode
     * @param string $desc
     * @param int $order
     * @param int $votes
     * @param string $answer
     * @param string $question
     */
    public function __construct($voCode = null, $desc = null, $order = null, $votes = null, $answer = null, $question = null)
    {
        $this
            ->setVoCode($voCode)
            ->setDesc($desc)
            ->setOrder($order)
            ->setVotes($votes)
            ->setAnswer($answer)
            ->setQuestion($question);
    }
    /**
     * Get voCode value
     * @return int|null
     */
    public function getVoCode()
    {
        return $this->voCode;
    }
    /**
     * Set voCode value
     * @param int $voCode
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public function setVoCode($voCode = null)
    {
        // validation for constraint: int
        if (!is_null($voCode) && !is_numeric($voCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($voCode)), __LINE__);
        }
        $this->voCode = $voCode;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get votes value
     * @return int|null
     */
    public function getVotes()
    {
        return $this->votes;
    }
    /**
     * Set votes value
     * @param int $votes
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public function setVotes($votes = null)
    {
        // validation for constraint: int
        if (!is_null($votes) && !is_numeric($votes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($votes)), __LINE__);
        }
        $this->votes = $votes;
        return $this;
    }
    /**
     * Get answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }
    /**
     * Set answer value
     * @param string $answer
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answer)), __LINE__);
        }
        $this->answer = $answer;
        return $this;
    }
    /**
     * Get question value
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->question;
    }
    /**
     * Set question value
     * @param string $question
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($question)), __LINE__);
        }
        $this->question = $question;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Option
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
