<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for oAuthRefreshRequest StructType
 * @subpackage Structs
 */
class OAuthRefreshRequest extends AbstractStructBase
{
    /**
     * The refreshToken
     * @var string
     */
    public $refreshToken;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The serviceAccessId
     * @var int
     */
    public $serviceAccessId;
    /**
     * The platform
     * @var string
     */
    public $platform;
    /**
     * The callbackURLType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callbackURLType;
    /**
     * Constructor method for oAuthRefreshRequest
     * @uses OAuthRefreshRequest::setRefreshToken()
     * @uses OAuthRefreshRequest::setOrgCode()
     * @uses OAuthRefreshRequest::setOrgMobilePassword()
     * @uses OAuthRefreshRequest::setServiceAccessId()
     * @uses OAuthRefreshRequest::setPlatform()
     * @uses OAuthRefreshRequest::setCallbackURLType()
     * @param string $refreshToken
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param int $serviceAccessId
     * @param string $platform
     * @param string $callbackURLType
     */
    public function __construct($refreshToken = null, $orgCode = null, $orgMobilePassword = null, $serviceAccessId = null, $platform = null, $callbackURLType = null)
    {
        $this
            ->setRefreshToken($refreshToken)
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setServiceAccessId($serviceAccessId)
            ->setPlatform($platform)
            ->setCallbackURLType($callbackURLType);
    }
    /**
     * Get refreshToken value
     * @return string|null
     */
    public function getRefreshToken()
    {
        return $this->refreshToken;
    }
    /**
     * Set refreshToken value
     * @param string $refreshToken
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public function setRefreshToken($refreshToken = null)
    {
        // validation for constraint: string
        if (!is_null($refreshToken) && !is_string($refreshToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refreshToken)), __LINE__);
        }
        $this->refreshToken = $refreshToken;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get serviceAccessId value
     * @return int|null
     */
    public function getServiceAccessId()
    {
        return $this->serviceAccessId;
    }
    /**
     * Set serviceAccessId value
     * @param int $serviceAccessId
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public function setServiceAccessId($serviceAccessId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAccessId) && !is_numeric($serviceAccessId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAccessId)), __LINE__);
        }
        $this->serviceAccessId = $serviceAccessId;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $platform, implode(', ', \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues())), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get callbackURLType value
     * @return string|null
     */
    public function getCallbackURLType()
    {
        return $this->callbackURLType;
    }
    /**
     * Set callbackURLType value
     * @param string $callbackURLType
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public function setCallbackURLType($callbackURLType = null)
    {
        // validation for constraint: string
        if (!is_null($callbackURLType) && !is_string($callbackURLType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callbackURLType)), __LINE__);
        }
        $this->callbackURLType = $callbackURLType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
