<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Notification[]
     */
    public $notification;
    /**
     * Constructor method for notifications
     * @uses Notifications::setNotification()
     * @param \QCC\CampusM\CloudService\StructType\Notification[] $notification
     */
    public function __construct(array $notification = array())
    {
        $this
            ->setNotification($notification);
    }
    /**
     * Get notification value
     * @return \QCC\CampusM\CloudService\StructType\Notification[]|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Notification[] $notification
     * @return \QCC\CampusM\CloudService\StructType\Notifications
     */
    public function setNotification(array $notification = array())
    {
        foreach ($notification as $notificationsNotificationItem) {
            // validation for constraint: itemType
            if (!$notificationsNotificationItem instanceof \QCC\CampusM\CloudService\StructType\Notification) {
                throw new \InvalidArgumentException(sprintf('The notification property can only contain items of \QCC\CampusM\CloudService\StructType\Notification, "%s" given', is_object($notificationsNotificationItem) ? get_class($notificationsNotificationItem) : gettype($notificationsNotificationItem)), __LINE__);
            }
        }
        $this->notification = $notification;
        return $this;
    }
    /**
     * Add item to notification value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Notification $item
     * @return \QCC\CampusM\CloudService\StructType\Notifications
     */
    public function addToNotification(\QCC\CampusM\CloudService\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The notification property can only contain items of \QCC\CampusM\CloudService\StructType\Notification, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->notification[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Notifications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
