<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listAvailableProfilesRequest StructType
 * @subpackage Structs
 */
class ListAvailableProfilesRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The platform
     * @var string
     */
    public $platform;
    /**
     * The languagePacksLastUpdated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $languagePacksLastUpdated;
    /**
     * The deviceModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deviceModel;
    /**
     * The oAuthCallbackURLType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthCallbackURLType;
    /**
     * Constructor method for listAvailableProfilesRequest
     * @uses ListAvailableProfilesRequest::setOrgCode()
     * @uses ListAvailableProfilesRequest::setOrgMobilePassword()
     * @uses ListAvailableProfilesRequest::setPlatform()
     * @uses ListAvailableProfilesRequest::setLanguagePacksLastUpdated()
     * @uses ListAvailableProfilesRequest::setDeviceModel()
     * @uses ListAvailableProfilesRequest::setOAuthCallbackURLType()
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param string $platform
     * @param string $languagePacksLastUpdated
     * @param string $deviceModel
     * @param string $oAuthCallbackURLType
     */
    public function __construct($orgCode = null, $orgMobilePassword = null, $platform = null, $languagePacksLastUpdated = null, $deviceModel = null, $oAuthCallbackURLType = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setPlatform($platform)
            ->setLanguagePacksLastUpdated($languagePacksLastUpdated)
            ->setDeviceModel($deviceModel)
            ->setOAuthCallbackURLType($oAuthCallbackURLType);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $platform, implode(', ', \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues())), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get languagePacksLastUpdated value
     * @return string|null
     */
    public function getLanguagePacksLastUpdated()
    {
        return $this->languagePacksLastUpdated;
    }
    /**
     * Set languagePacksLastUpdated value
     * @param string $languagePacksLastUpdated
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public function setLanguagePacksLastUpdated($languagePacksLastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($languagePacksLastUpdated) && !is_string($languagePacksLastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languagePacksLastUpdated)), __LINE__);
        }
        $this->languagePacksLastUpdated = $languagePacksLastUpdated;
        return $this;
    }
    /**
     * Get deviceModel value
     * @return string|null
     */
    public function getDeviceModel()
    {
        return $this->deviceModel;
    }
    /**
     * Set deviceModel value
     * @param string $deviceModel
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public function setDeviceModel($deviceModel = null)
    {
        // validation for constraint: string
        if (!is_null($deviceModel) && !is_string($deviceModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceModel)), __LINE__);
        }
        $this->deviceModel = $deviceModel;
        return $this;
    }
    /**
     * Get oAuthCallbackURLType value
     * @return string|null
     */
    public function getOAuthCallbackURLType()
    {
        return $this->oAuthCallbackURLType;
    }
    /**
     * Set oAuthCallbackURLType value
     * @param string $oAuthCallbackURLType
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public function setOAuthCallbackURLType($oAuthCallbackURLType = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthCallbackURLType) && !is_string($oAuthCallbackURLType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthCallbackURLType)), __LINE__);
        }
        $this->oAuthCallbackURLType = $oAuthCallbackURLType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
