<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemReferences StructType
 * @subpackage Structs
 */
class ItemReferences extends AbstractStructBase
{
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $reference;
    /**
     * Constructor method for itemReferences
     * @uses ItemReferences::setReference()
     * @param string[] $reference
     */
    public function __construct(array $reference = array())
    {
        $this
            ->setReference($reference);
    }
    /**
     * Get reference value
     * @return string[]|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @throws \InvalidArgumentException
     * @param string[] $reference
     * @return \QCC\CampusM\CloudService\StructType\ItemReferences
     */
    public function setReference(array $reference = array())
    {
        foreach ($reference as $itemReferencesReferenceItem) {
            // validation for constraint: itemType
            if (!is_string($itemReferencesReferenceItem)) {
                throw new \InvalidArgumentException(sprintf('The reference property can only contain items of string, "%s" given', is_object($itemReferencesReferenceItem) ? get_class($itemReferencesReferenceItem) : gettype($itemReferencesReferenceItem)), __LINE__);
            }
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Add item to reference value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\ItemReferences
     */
    public function addToReference($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The reference property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->reference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ItemReferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
