<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for insertDirectoryListRequest StructType
 * @subpackage Structs
 */
class InsertDirectoryListRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The first_name
     * @var string
     */
    public $first_name;
    /**
     * The last_name
     * @var string
     */
    public $last_name;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The organisation
     * @var string
     */
    public $organisation;
    /**
     * The job_title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $job_title;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The opt_in
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $opt_in;
    /**
     * The profileId
     * @var int
     */
    public $profileId;
    /**
     * Constructor method for insertDirectoryListRequest
     * @uses InsertDirectoryListRequest::setOrgCode()
     * @uses InsertDirectoryListRequest::setPersonId()
     * @uses InsertDirectoryListRequest::setPassword()
     * @uses InsertDirectoryListRequest::setFirst_name()
     * @uses InsertDirectoryListRequest::setLast_name()
     * @uses InsertDirectoryListRequest::setEmail()
     * @uses InsertDirectoryListRequest::setOrganisation()
     * @uses InsertDirectoryListRequest::setJob_title()
     * @uses InsertDirectoryListRequest::setDepartment()
     * @uses InsertDirectoryListRequest::setAddress()
     * @uses InsertDirectoryListRequest::setCountry()
     * @uses InsertDirectoryListRequest::setOpt_in()
     * @uses InsertDirectoryListRequest::setProfileId()
     * @param int $orgCode
     * @param int $personId
     * @param string $password
     * @param string $first_name
     * @param string $last_name
     * @param string $email
     * @param string $organisation
     * @param string $job_title
     * @param string $department
     * @param string $address
     * @param string $country
     * @param string $opt_in
     * @param int $profileId
     */
    public function __construct($orgCode = null, $personId = null, $password = null, $first_name = null, $last_name = null, $email = null, $organisation = null, $job_title = null, $department = null, $address = null, $country = null, $opt_in = null, $profileId = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPersonId($personId)
            ->setPassword($password)
            ->setFirst_name($first_name)
            ->setLast_name($last_name)
            ->setEmail($email)
            ->setOrganisation($organisation)
            ->setJob_title($job_title)
            ->setDepartment($department)
            ->setAddress($address)
            ->setCountry($country)
            ->setOpt_in($opt_in)
            ->setProfileId($profileId);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get first_name value
     * @return string|null
     */
    public function getFirst_name()
    {
        return $this->first_name;
    }
    /**
     * Set first_name value
     * @param string $first_name
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setFirst_name($first_name = null)
    {
        // validation for constraint: string
        if (!is_null($first_name) && !is_string($first_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first_name)), __LINE__);
        }
        $this->first_name = $first_name;
        return $this;
    }
    /**
     * Get last_name value
     * @return string|null
     */
    public function getLast_name()
    {
        return $this->last_name;
    }
    /**
     * Set last_name value
     * @param string $last_name
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setLast_name($last_name = null)
    {
        // validation for constraint: string
        if (!is_null($last_name) && !is_string($last_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_name)), __LINE__);
        }
        $this->last_name = $last_name;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get job_title value
     * @return string|null
     */
    public function getJob_title()
    {
        return $this->job_title;
    }
    /**
     * Set job_title value
     * @param string $job_title
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setJob_title($job_title = null)
    {
        // validation for constraint: string
        if (!is_null($job_title) && !is_string($job_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($job_title)), __LINE__);
        }
        $this->job_title = $job_title;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get opt_in value
     * @return string|null
     */
    public function getOpt_in()
    {
        return $this->opt_in;
    }
    /**
     * Set opt_in value
     * @param string $opt_in
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setOpt_in($opt_in = null)
    {
        // validation for constraint: string
        if (!is_null($opt_in) && !is_string($opt_in)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opt_in)), __LINE__);
        }
        $this->opt_in = $opt_in;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
