<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for indexQuery StructType
 * @subpackage Structs
 */
class IndexQuery extends AbstractStructBase
{
    /**
     * The indexName
     * @var string
     */
    public $indexName;
    /**
     * The minValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minValue;
    /**
     * The maxValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $maxValue;
    /**
     * The likeExpression
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $likeExpression;
    /**
     * Constructor method for indexQuery
     * @uses IndexQuery::setIndexName()
     * @uses IndexQuery::setMinValue()
     * @uses IndexQuery::setMaxValue()
     * @uses IndexQuery::setLikeExpression()
     * @param string $indexName
     * @param string $minValue
     * @param string $maxValue
     * @param string $likeExpression
     */
    public function __construct($indexName = null, $minValue = null, $maxValue = null, $likeExpression = null)
    {
        $this
            ->setIndexName($indexName)
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setLikeExpression($likeExpression);
    }
    /**
     * Get indexName value
     * @return string|null
     */
    public function getIndexName()
    {
        return $this->indexName;
    }
    /**
     * Set indexName value
     * @param string $indexName
     * @return \QCC\CampusM\CloudService\StructType\IndexQuery
     */
    public function setIndexName($indexName = null)
    {
        // validation for constraint: string
        if (!is_null($indexName) && !is_string($indexName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indexName)), __LINE__);
        }
        $this->indexName = $indexName;
        return $this;
    }
    /**
     * Get minValue value
     * @return string|null
     */
    public function getMinValue()
    {
        return $this->minValue;
    }
    /**
     * Set minValue value
     * @param string $minValue
     * @return \QCC\CampusM\CloudService\StructType\IndexQuery
     */
    public function setMinValue($minValue = null)
    {
        // validation for constraint: string
        if (!is_null($minValue) && !is_string($minValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minValue)), __LINE__);
        }
        $this->minValue = $minValue;
        return $this;
    }
    /**
     * Get maxValue value
     * @return string|null
     */
    public function getMaxValue()
    {
        return $this->maxValue;
    }
    /**
     * Set maxValue value
     * @param string $maxValue
     * @return \QCC\CampusM\CloudService\StructType\IndexQuery
     */
    public function setMaxValue($maxValue = null)
    {
        // validation for constraint: string
        if (!is_null($maxValue) && !is_string($maxValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxValue)), __LINE__);
        }
        $this->maxValue = $maxValue;
        return $this;
    }
    /**
     * Get likeExpression value
     * @return string|null
     */
    public function getLikeExpression()
    {
        return $this->likeExpression;
    }
    /**
     * Set likeExpression value
     * @param string $likeExpression
     * @return \QCC\CampusM\CloudService\StructType\IndexQuery
     */
    public function setLikeExpression($likeExpression = null)
    {
        // validation for constraint: string
        if (!is_null($likeExpression) && !is_string($likeExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($likeExpression)), __LINE__);
        }
        $this->likeExpression = $likeExpression;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\IndexQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
