<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRefLookupsRequest StructType
 * @subpackage Structs
 */
class GetRefLookupsRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The servicePassword
     * @var string
     */
    public $servicePassword;
    /**
     * Constructor method for getRefLookupsRequest
     * @uses GetRefLookupsRequest::setOrgCode()
     * @uses GetRefLookupsRequest::setServicePassword()
     * @param int $orgCode
     * @param string $servicePassword
     */
    public function __construct($orgCode = null, $servicePassword = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setServicePassword($servicePassword);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\GetRefLookupsRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get servicePassword value
     * @return string|null
     */
    public function getServicePassword()
    {
        return $this->servicePassword;
    }
    /**
     * Set servicePassword value
     * @param string $servicePassword
     * @return \QCC\CampusM\CloudService\StructType\GetRefLookupsRequest
     */
    public function setServicePassword($servicePassword = null)
    {
        // validation for constraint: string
        if (!is_null($servicePassword) && !is_string($servicePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePassword)), __LINE__);
        }
        $this->servicePassword = $servicePassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\GetRefLookupsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
