<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPersonalisationConfigResponse StructType
 * @subpackage Structs
 */
class GetPersonalisationConfigResponse extends AbstractStructBase
{
    /**
     * The profileId
     * @var int
     */
    public $profileId;
    /**
     * The userPersonalisationLastUpdated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userPersonalisationLastUpdated;
    /**
     * The personConfigJson
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $personConfigJson;
    /**
     * Constructor method for getPersonalisationConfigResponse
     * @uses GetPersonalisationConfigResponse::setProfileId()
     * @uses GetPersonalisationConfigResponse::setUserPersonalisationLastUpdated()
     * @uses GetPersonalisationConfigResponse::setPersonConfigJson()
     * @param int $profileId
     * @param string $userPersonalisationLastUpdated
     * @param string $personConfigJson
     */
    public function __construct($profileId = null, $userPersonalisationLastUpdated = null, $personConfigJson = null)
    {
        $this
            ->setProfileId($profileId)
            ->setUserPersonalisationLastUpdated($userPersonalisationLastUpdated)
            ->setPersonConfigJson($personConfigJson);
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigResponse
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get userPersonalisationLastUpdated value
     * @return string|null
     */
    public function getUserPersonalisationLastUpdated()
    {
        return $this->userPersonalisationLastUpdated;
    }
    /**
     * Set userPersonalisationLastUpdated value
     * @param string $userPersonalisationLastUpdated
     * @return \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigResponse
     */
    public function setUserPersonalisationLastUpdated($userPersonalisationLastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($userPersonalisationLastUpdated) && !is_string($userPersonalisationLastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPersonalisationLastUpdated)), __LINE__);
        }
        $this->userPersonalisationLastUpdated = $userPersonalisationLastUpdated;
        return $this;
    }
    /**
     * Get personConfigJson value
     * @return string|null
     */
    public function getPersonConfigJson()
    {
        return $this->personConfigJson;
    }
    /**
     * Set personConfigJson value
     * @param string $personConfigJson
     * @return \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigResponse
     */
    public function setPersonConfigJson($personConfigJson = null)
    {
        // validation for constraint: string
        if (!is_null($personConfigJson) && !is_string($personConfigJson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personConfigJson)), __LINE__);
        }
        $this->personConfigJson = $personConfigJson;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
