<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFeedItemsRequest StructType
 * @subpackage Structs
 */
class GetFeedItemsRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The feedType
     * @var string
     */
    public $feedType;
    /**
     * The feedGroupReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $feedGroupReference;
    /**
     * The combineQueriesType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $combineQueriesType;
    /**
     * The indexQueries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\IndexQueries
     */
    public $indexQueries;
    /**
     * The itemReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ItemReferences
     */
    public $itemReferences;
    /**
     * The readExpressions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ReadExpressions
     */
    public $readExpressions;
    /**
     * Constructor method for getFeedItemsRequest
     * @uses GetFeedItemsRequest::setOrgCode()
     * @uses GetFeedItemsRequest::setOrgMobilePassword()
     * @uses GetFeedItemsRequest::setFeedType()
     * @uses GetFeedItemsRequest::setFeedGroupReference()
     * @uses GetFeedItemsRequest::setCombineQueriesType()
     * @uses GetFeedItemsRequest::setIndexQueries()
     * @uses GetFeedItemsRequest::setItemReferences()
     * @uses GetFeedItemsRequest::setReadExpressions()
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param string $feedType
     * @param string $feedGroupReference
     * @param string $combineQueriesType
     * @param \QCC\CampusM\CloudService\StructType\IndexQueries $indexQueries
     * @param \QCC\CampusM\CloudService\StructType\ItemReferences $itemReferences
     * @param \QCC\CampusM\CloudService\StructType\ReadExpressions $readExpressions
     */
    public function __construct($orgCode = null, $orgMobilePassword = null, $feedType = null, $feedGroupReference = null, $combineQueriesType = null, \QCC\CampusM\CloudService\StructType\IndexQueries $indexQueries = null, \QCC\CampusM\CloudService\StructType\ItemReferences $itemReferences = null, \QCC\CampusM\CloudService\StructType\ReadExpressions $readExpressions = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setFeedType($feedType)
            ->setFeedGroupReference($feedGroupReference)
            ->setCombineQueriesType($combineQueriesType)
            ->setIndexQueries($indexQueries)
            ->setItemReferences($itemReferences)
            ->setReadExpressions($readExpressions);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get feedType value
     * @return string|null
     */
    public function getFeedType()
    {
        return $this->feedType;
    }
    /**
     * Set feedType value
     * @param string $feedType
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setFeedType($feedType = null)
    {
        // validation for constraint: string
        if (!is_null($feedType) && !is_string($feedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedType)), __LINE__);
        }
        $this->feedType = $feedType;
        return $this;
    }
    /**
     * Get feedGroupReference value
     * @return string|null
     */
    public function getFeedGroupReference()
    {
        return $this->feedGroupReference;
    }
    /**
     * Set feedGroupReference value
     * @param string $feedGroupReference
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setFeedGroupReference($feedGroupReference = null)
    {
        // validation for constraint: string
        if (!is_null($feedGroupReference) && !is_string($feedGroupReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedGroupReference)), __LINE__);
        }
        $this->feedGroupReference = $feedGroupReference;
        return $this;
    }
    /**
     * Get combineQueriesType value
     * @return string|null
     */
    public function getCombineQueriesType()
    {
        return $this->combineQueriesType;
    }
    /**
     * Set combineQueriesType value
     * @param string $combineQueriesType
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setCombineQueriesType($combineQueriesType = null)
    {
        // validation for constraint: string
        if (!is_null($combineQueriesType) && !is_string($combineQueriesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($combineQueriesType)), __LINE__);
        }
        $this->combineQueriesType = $combineQueriesType;
        return $this;
    }
    /**
     * Get indexQueries value
     * @return \QCC\CampusM\CloudService\StructType\IndexQueries|null
     */
    public function getIndexQueries()
    {
        return $this->indexQueries;
    }
    /**
     * Set indexQueries value
     * @param \QCC\CampusM\CloudService\StructType\IndexQueries $indexQueries
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setIndexQueries(\QCC\CampusM\CloudService\StructType\IndexQueries $indexQueries = null)
    {
        $this->indexQueries = $indexQueries;
        return $this;
    }
    /**
     * Get itemReferences value
     * @return \QCC\CampusM\CloudService\StructType\ItemReferences|null
     */
    public function getItemReferences()
    {
        return $this->itemReferences;
    }
    /**
     * Set itemReferences value
     * @param \QCC\CampusM\CloudService\StructType\ItemReferences $itemReferences
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setItemReferences(\QCC\CampusM\CloudService\StructType\ItemReferences $itemReferences = null)
    {
        $this->itemReferences = $itemReferences;
        return $this;
    }
    /**
     * Get readExpressions value
     * @return \QCC\CampusM\CloudService\StructType\ReadExpressions|null
     */
    public function getReadExpressions()
    {
        return $this->readExpressions;
    }
    /**
     * Set readExpressions value
     * @param \QCC\CampusM\CloudService\StructType\ReadExpressions $readExpressions
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public function setReadExpressions(\QCC\CampusM\CloudService\StructType\ReadExpressions $readExpressions = null)
    {
        $this->readExpressions = $readExpressions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
