<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for expireFeedsSurveysRequest StructType
 * @subpackage Structs
 */
class ExpireFeedsSurveysRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The profileId
     * @var int
     */
    public $profileId;
    /**
     * The setExpired
     * Meta informations extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $setExpired;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expiryDate;
    /**
     * Constructor method for expireFeedsSurveysRequest
     * @uses ExpireFeedsSurveysRequest::setOrgCode()
     * @uses ExpireFeedsSurveysRequest::setPassword()
     * @uses ExpireFeedsSurveysRequest::setProfileId()
     * @uses ExpireFeedsSurveysRequest::setSetExpired()
     * @uses ExpireFeedsSurveysRequest::setExpiryDate()
     * @param int $orgCode
     * @param string $password
     * @param int $profileId
     * @param bool $setExpired
     * @param string $expiryDate
     */
    public function __construct($orgCode = null, $password = null, $profileId = null, $setExpired = true, $expiryDate = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setProfileId($profileId)
            ->setSetExpired($setExpired)
            ->setExpiryDate($expiryDate);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get setExpired value
     * @return bool|null
     */
    public function getSetExpired()
    {
        return $this->setExpired;
    }
    /**
     * Set setExpired value
     * @param bool $setExpired
     * @return \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest
     */
    public function setSetExpired($setExpired = true)
    {
        // validation for constraint: boolean
        if (!is_null($setExpired) && !is_bool($setExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($setExpired)), __LINE__);
        }
        $this->setExpired = $setExpired;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
