<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for emails StructType
 * @subpackage Structs
 */
class Emails extends AbstractStructBase
{
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $email;
    /**
     * Constructor method for emails
     * @uses Emails::setEmail()
     * @param string[] $email
     */
    public function __construct(array $email = array())
    {
        $this
            ->setEmail($email);
    }
    /**
     * Get email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \QCC\CampusM\CloudService\StructType\Emails
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $emailsEmailItem) {
            // validation for constraint: itemType
            if (!is_string($emailsEmailItem)) {
                throw new \InvalidArgumentException(sprintf('The email property can only contain items of string, "%s" given', is_object($emailsEmailItem) ? get_class($emailsEmailItem) : gettype($emailsEmailItem)), __LINE__);
            }
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Add item to email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\Emails
     */
    public function addToEmail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The email property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->email[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Emails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
