<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteAlertsRequest StructType
 * @subpackage Structs
 */
class DeleteAlertsRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The updt
     * @var string
     */
    public $updt;
    /**
     * The alerts
     * @var \QCC\CampusM\CloudService\StructType\Alerts
     */
    public $alerts;
    /**
     * Constructor method for deleteAlertsRequest
     * @uses DeleteAlertsRequest::setPersonId()
     * @uses DeleteAlertsRequest::setPassword()
     * @uses DeleteAlertsRequest::setUpdt()
     * @uses DeleteAlertsRequest::setAlerts()
     * @param int $personId
     * @param string $password
     * @param string $updt
     * @param \QCC\CampusM\CloudService\StructType\Alerts $alerts
     */
    public function __construct($personId = null, $password = null, $updt = null, \QCC\CampusM\CloudService\StructType\Alerts $alerts = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setUpdt($updt)
            ->setAlerts($alerts);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get updt value
     * @return string|null
     */
    public function getUpdt()
    {
        return $this->updt;
    }
    /**
     * Set updt value
     * @param string $updt
     * @return \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest
     */
    public function setUpdt($updt = null)
    {
        // validation for constraint: string
        if (!is_null($updt) && !is_string($updt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updt)), __LINE__);
        }
        $this->updt = $updt;
        return $this;
    }
    /**
     * Get alerts value
     * @return \QCC\CampusM\CloudService\StructType\Alerts|null
     */
    public function getAlerts()
    {
        return $this->alerts;
    }
    /**
     * Set alerts value
     * @param \QCC\CampusM\CloudService\StructType\Alerts $alerts
     * @return \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest
     */
    public function setAlerts(\QCC\CampusM\CloudService\StructType\Alerts $alerts = null)
    {
        $this->alerts = $alerts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
