<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkInLocation StructType
 * @subpackage Structs
 */
class CheckInLocation extends AbstractStructBase
{
    /**
     * The location
     * @var string
     */
    public $location;
    /**
     * The positionId
     * @var int
     */
    public $positionId;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $image;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $note;
    /**
     * The favourite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $favourite;
    /**
     * The lastCheckIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lastCheckIn;
    /**
     * The distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $distance;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $longitude;
    /**
     * The friends
     * @var \QCC\CampusM\CloudService\StructType\LocationFriends
     */
    public $friends;
    /**
     * Constructor method for checkInLocation
     * @uses CheckInLocation::setLocation()
     * @uses CheckInLocation::setPositionId()
     * @uses CheckInLocation::setDescription()
     * @uses CheckInLocation::setImage()
     * @uses CheckInLocation::setNote()
     * @uses CheckInLocation::setFavourite()
     * @uses CheckInLocation::setLastCheckIn()
     * @uses CheckInLocation::setDistance()
     * @uses CheckInLocation::setLatitude()
     * @uses CheckInLocation::setLongitude()
     * @uses CheckInLocation::setFriends()
     * @param string $location
     * @param int $positionId
     * @param string $description
     * @param string $image
     * @param string $note
     * @param string $favourite
     * @param string $lastCheckIn
     * @param float $distance
     * @param float $latitude
     * @param float $longitude
     * @param \QCC\CampusM\CloudService\StructType\LocationFriends $friends
     */
    public function __construct($location = null, $positionId = null, $description = null, $image = null, $note = null, $favourite = null, $lastCheckIn = null, $distance = null, $latitude = null, $longitude = null, \QCC\CampusM\CloudService\StructType\LocationFriends $friends = null)
    {
        $this
            ->setLocation($location)
            ->setPositionId($positionId)
            ->setDescription($description)
            ->setImage($image)
            ->setNote($note)
            ->setFavourite($favourite)
            ->setLastCheckIn($lastCheckIn)
            ->setDistance($distance)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setFriends($friends);
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get positionId value
     * @return int|null
     */
    public function getPositionId()
    {
        return $this->positionId;
    }
    /**
     * Set positionId value
     * @param int $positionId
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setPositionId($positionId = null)
    {
        // validation for constraint: int
        if (!is_null($positionId) && !is_numeric($positionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($positionId)), __LINE__);
        }
        $this->positionId = $positionId;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->image) ? $this->image : null;
    }
    /**
     * Set image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->image);
        } else {
            $this->image = $image;
        }
        return $this;
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Get favourite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFavourite()
    {
        return isset($this->favourite) ? $this->favourite : null;
    }
    /**
     * Set favourite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $favourite
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setFavourite($favourite = null)
    {
        // validation for constraint: string
        if (!is_null($favourite) && !is_string($favourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($favourite)), __LINE__);
        }
        if (is_null($favourite) || (is_array($favourite) && empty($favourite))) {
            unset($this->favourite);
        } else {
            $this->favourite = $favourite;
        }
        return $this;
    }
    /**
     * Get lastCheckIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCheckIn()
    {
        return isset($this->lastCheckIn) ? $this->lastCheckIn : null;
    }
    /**
     * Set lastCheckIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCheckIn
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setLastCheckIn($lastCheckIn = null)
    {
        // validation for constraint: string
        if (!is_null($lastCheckIn) && !is_string($lastCheckIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCheckIn)), __LINE__);
        }
        if (is_null($lastCheckIn) || (is_array($lastCheckIn) && empty($lastCheckIn))) {
            unset($this->lastCheckIn);
        } else {
            $this->lastCheckIn = $lastCheckIn;
        }
        return $this;
    }
    /**
     * Get distance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDistance()
    {
        return isset($this->distance) ? $this->distance : null;
    }
    /**
     * Set distance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $distance
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setDistance($distance = null)
    {
        if (is_null($distance) || (is_array($distance) && empty($distance))) {
            unset($this->distance);
        } else {
            $this->distance = $distance;
        }
        return $this;
    }
    /**
     * Get latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitude()
    {
        return isset($this->latitude) ? $this->latitude : null;
    }
    /**
     * Set latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitude
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setLatitude($latitude = null)
    {
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->latitude);
        } else {
            $this->latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitude()
    {
        return isset($this->longitude) ? $this->longitude : null;
    }
    /**
     * Set longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitude
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setLongitude($longitude = null)
    {
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->longitude);
        } else {
            $this->longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get friends value
     * @return \QCC\CampusM\CloudService\StructType\LocationFriends|null
     */
    public function getFriends()
    {
        return $this->friends;
    }
    /**
     * Set friends value
     * @param \QCC\CampusM\CloudService\StructType\LocationFriends $friends
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public function setFriends(\QCC\CampusM\CloudService\StructType\LocationFriends $friends = null)
    {
        $this->friends = $friends;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
