<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for categories StructType
 * @subpackage Structs
 */
class Categories extends AbstractStructBase
{
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Category[]
     */
    public $category;
    /**
     * Constructor method for categories
     * @uses Categories::setCategory()
     * @param \QCC\CampusM\CloudService\StructType\Category[] $category
     */
    public function __construct(array $category = array())
    {
        $this
            ->setCategory($category);
    }
    /**
     * Get category value
     * @return \QCC\CampusM\CloudService\StructType\Category[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Category[] $category
     * @return \QCC\CampusM\CloudService\StructType\Categories
     */
    public function setCategory(array $category = array())
    {
        foreach ($category as $categoriesCategoryItem) {
            // validation for constraint: itemType
            if (!$categoriesCategoryItem instanceof \QCC\CampusM\CloudService\StructType\Category) {
                throw new \InvalidArgumentException(sprintf('The category property can only contain items of \QCC\CampusM\CloudService\StructType\Category, "%s" given', is_object($categoriesCategoryItem) ? get_class($categoriesCategoryItem) : gettype($categoriesCategoryItem)), __LINE__);
            }
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Category $item
     * @return \QCC\CampusM\CloudService\StructType\Categories
     */
    public function addToCategory(\QCC\CampusM\CloudService\StructType\Category $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Category) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of \QCC\CampusM\CloudService\StructType\Category, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Categories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
