<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cachedPocketGuide StructType
 * @subpackage Structs
 */
class CachedPocketGuide extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The menuCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $menuCode;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * Constructor method for cachedPocketGuide
     * @uses CachedPocketGuide::setPersonId()
     * @uses CachedPocketGuide::setPassword()
     * @uses CachedPocketGuide::setMenuCode()
     * @uses CachedPocketGuide::setProfileId()
     * @param int $personId
     * @param string $password
     * @param string $menuCode
     * @param int $profileId
     */
    public function __construct($personId = null, $password = null, $menuCode = null, $profileId = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setMenuCode($menuCode)
            ->setProfileId($profileId);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\CachedPocketGuide
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\CachedPocketGuide
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get menuCode value
     * @return string|null
     */
    public function getMenuCode()
    {
        return $this->menuCode;
    }
    /**
     * Set menuCode value
     * @param string $menuCode
     * @return \QCC\CampusM\CloudService\StructType\CachedPocketGuide
     */
    public function setMenuCode($menuCode = null)
    {
        // validation for constraint: string
        if (!is_null($menuCode) && !is_string($menuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuCode)), __LINE__);
        }
        $this->menuCode = $menuCode;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\CachedPocketGuide
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CachedPocketGuide
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
