<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cachedMapItems StructType
 * @subpackage Structs
 */
class CachedMapItems extends AbstractStructBase
{
    /**
     * The mapItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\MapItem[]
     */
    public $mapItem;
    /**
     * Constructor method for cachedMapItems
     * @uses CachedMapItems::setMapItem()
     * @param \QCC\CampusM\CloudService\StructType\MapItem[] $mapItem
     */
    public function __construct(array $mapItem = array())
    {
        $this
            ->setMapItem($mapItem);
    }
    /**
     * Get mapItem value
     * @return \QCC\CampusM\CloudService\StructType\MapItem[]|null
     */
    public function getMapItem()
    {
        return $this->mapItem;
    }
    /**
     * Set mapItem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\MapItem[] $mapItem
     * @return \QCC\CampusM\CloudService\StructType\CachedMapItems
     */
    public function setMapItem(array $mapItem = array())
    {
        foreach ($mapItem as $cachedMapItemsMapItemItem) {
            // validation for constraint: itemType
            if (!$cachedMapItemsMapItemItem instanceof \QCC\CampusM\CloudService\StructType\MapItem) {
                throw new \InvalidArgumentException(sprintf('The mapItem property can only contain items of \QCC\CampusM\CloudService\StructType\MapItem, "%s" given', is_object($cachedMapItemsMapItemItem) ? get_class($cachedMapItemsMapItemItem) : gettype($cachedMapItemsMapItemItem)), __LINE__);
            }
        }
        $this->mapItem = $mapItem;
        return $this;
    }
    /**
     * Add item to mapItem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\MapItem $item
     * @return \QCC\CampusM\CloudService\StructType\CachedMapItems
     */
    public function addToMapItem(\QCC\CampusM\CloudService\StructType\MapItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\MapItem) {
            throw new \InvalidArgumentException(sprintf('The mapItem property can only contain items of \QCC\CampusM\CloudService\StructType\MapItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mapItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CachedMapItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
