<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookmark StructType
 * @subpackage Structs
 */
class Bookmark extends AbstractStructBase
{
    /**
     * The pgCode
     * @var int
     */
    public $pgCode;
    /**
     * The sortOrder
     * @var string
     */
    public $sortOrder;
    /**
     * Constructor method for bookmark
     * @uses Bookmark::setPgCode()
     * @uses Bookmark::setSortOrder()
     * @param int $pgCode
     * @param string $sortOrder
     */
    public function __construct($pgCode = null, $sortOrder = null)
    {
        $this
            ->setPgCode($pgCode)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get pgCode value
     * @return int|null
     */
    public function getPgCode()
    {
        return $this->pgCode;
    }
    /**
     * Set pgCode value
     * @param int $pgCode
     * @return \QCC\CampusM\CloudService\StructType\Bookmark
     */
    public function setPgCode($pgCode = null)
    {
        // validation for constraint: int
        if (!is_null($pgCode) && !is_numeric($pgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pgCode)), __LINE__);
        }
        $this->pgCode = $pgCode;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param string $sortOrder
     * @return \QCC\CampusM\CloudService\StructType\Bookmark
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: string
        if (!is_null($sortOrder) && !is_string($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Bookmark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
