<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authGroups StructType
 * @subpackage Structs
 */
class AuthGroups extends AbstractStructBase
{
    /**
     * The authGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $authGroup;
    /**
     * Constructor method for authGroups
     * @uses AuthGroups::setAuthGroup()
     * @param string[] $authGroup
     */
    public function __construct(array $authGroup = array())
    {
        $this
            ->setAuthGroup($authGroup);
    }
    /**
     * Get authGroup value
     * @return string[]|null
     */
    public function getAuthGroup()
    {
        return $this->authGroup;
    }
    /**
     * Set authGroup value
     * @throws \InvalidArgumentException
     * @param string[] $authGroup
     * @return \QCC\CampusM\CloudService\StructType\AuthGroups
     */
    public function setAuthGroup(array $authGroup = array())
    {
        foreach ($authGroup as $authGroupsAuthGroupItem) {
            // validation for constraint: itemType
            if (!is_string($authGroupsAuthGroupItem)) {
                throw new \InvalidArgumentException(sprintf('The authGroup property can only contain items of string, "%s" given', is_object($authGroupsAuthGroupItem) ? get_class($authGroupsAuthGroupItem) : gettype($authGroupsAuthGroupItem)), __LINE__);
            }
        }
        $this->authGroup = $authGroup;
        return $this;
    }
    /**
     * Add item to authGroup value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\AuthGroups
     */
    public function addToAuthGroup($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The authGroup property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->authGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AuthGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
