<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for assetValue StructType
 * @subpackage Structs
 */
class AssetValue extends AssetIdentifier
{
    /**
     * The groupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $groupId;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The values
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\AssetValues
     */
    public $values;
    /**
     * Constructor method for assetValue
     * @uses AssetValue::setGroupId()
     * @uses AssetValue::setValue()
     * @uses AssetValue::setValues()
     * @param int $groupId
     * @param string $value
     * @param \QCC\CampusM\CloudService\StructType\AssetValues $values
     */
    public function __construct($groupId = null, $value = null, \QCC\CampusM\CloudService\StructType\AssetValues $values = null)
    {
        $this
            ->setGroupId($groupId)
            ->setValue($value)
            ->setValues($values);
    }
    /**
     * Get groupId value
     * @return int|null
     */
    public function getGroupId()
    {
        return $this->groupId;
    }
    /**
     * Set groupId value
     * @param int $groupId
     * @return \QCC\CampusM\CloudService\StructType\AssetValue
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->groupId = $groupId;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \QCC\CampusM\CloudService\StructType\AssetValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get values value
     * @return \QCC\CampusM\CloudService\StructType\AssetValues|null
     */
    public function getValues()
    {
        return $this->values;
    }
    /**
     * Set values value
     * @param \QCC\CampusM\CloudService\StructType\AssetValues $values
     * @return \QCC\CampusM\CloudService\StructType\AssetValue
     */
    public function setValues(\QCC\CampusM\CloudService\StructType\AssetValues $values = null)
    {
        $this->values = $values;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AssetValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
