<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appUser StructType
 * @subpackage Structs
 */
class AppUser extends AbstractStructBase
{
    /**
     * The recordId
     * @var int
     */
    public $recordId;
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The secondName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondName;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateLastUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateLastUsed;
    /**
     * Constructor method for appUser
     * @uses AppUser::setRecordId()
     * @uses AppUser::setPersonId()
     * @uses AppUser::setFirstName()
     * @uses AppUser::setSecondName()
     * @uses AppUser::setEmail()
     * @uses AppUser::setDateRegistered()
     * @uses AppUser::setDateLastUsed()
     * @param int $recordId
     * @param int $personId
     * @param string $firstName
     * @param string $secondName
     * @param string $email
     * @param string $dateRegistered
     * @param string $dateLastUsed
     */
    public function __construct($recordId = null, $personId = null, $firstName = null, $secondName = null, $email = null, $dateRegistered = null, $dateLastUsed = null)
    {
        $this
            ->setRecordId($recordId)
            ->setPersonId($personId)
            ->setFirstName($firstName)
            ->setSecondName($secondName)
            ->setEmail($email)
            ->setDateRegistered($dateRegistered)
            ->setDateLastUsed($dateLastUsed);
    }
    /**
     * Get recordId value
     * @return int|null
     */
    public function getRecordId()
    {
        return $this->recordId;
    }
    /**
     * Set recordId value
     * @param int $recordId
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: int
        if (!is_null($recordId) && !is_numeric($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordId)), __LINE__);
        }
        $this->recordId = $recordId;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get secondName value
     * @return string|null
     */
    public function getSecondName()
    {
        return $this->secondName;
    }
    /**
     * Set secondName value
     * @param string $secondName
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setSecondName($secondName = null)
    {
        // validation for constraint: string
        if (!is_null($secondName) && !is_string($secondName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondName)), __LINE__);
        }
        $this->secondName = $secondName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateLastUsed value
     * @return string|null
     */
    public function getDateLastUsed()
    {
        return $this->dateLastUsed;
    }
    /**
     * Set dateLastUsed value
     * @param string $dateLastUsed
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public function setDateLastUsed($dateLastUsed = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastUsed) && !is_string($dateLastUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateLastUsed)), __LINE__);
        }
        $this->dateLastUsed = $dateLastUsed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AppUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
