<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adverts StructType
 * @subpackage Structs
 */
class Adverts extends AbstractStructBase
{
    /**
     * The advert
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Advert[]
     */
    public $advert;
    /**
     * Constructor method for adverts
     * @uses Adverts::setAdvert()
     * @param \QCC\CampusM\CloudService\StructType\Advert[] $advert
     */
    public function __construct(array $advert = array())
    {
        $this
            ->setAdvert($advert);
    }
    /**
     * Get advert value
     * @return \QCC\CampusM\CloudService\StructType\Advert[]|null
     */
    public function getAdvert()
    {
        return $this->advert;
    }
    /**
     * Set advert value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Advert[] $advert
     * @return \QCC\CampusM\CloudService\StructType\Adverts
     */
    public function setAdvert(array $advert = array())
    {
        foreach ($advert as $advertsAdvertItem) {
            // validation for constraint: itemType
            if (!$advertsAdvertItem instanceof \QCC\CampusM\CloudService\StructType\Advert) {
                throw new \InvalidArgumentException(sprintf('The advert property can only contain items of \QCC\CampusM\CloudService\StructType\Advert, "%s" given', is_object($advertsAdvertItem) ? get_class($advertsAdvertItem) : gettype($advertsAdvertItem)), __LINE__);
            }
        }
        $this->advert = $advert;
        return $this;
    }
    /**
     * Add item to advert value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Advert $item
     * @return \QCC\CampusM\CloudService\StructType\Adverts
     */
    public function addToAdvert(\QCC\CampusM\CloudService\StructType\Advert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Advert) {
            throw new \InvalidArgumentException(sprintf('The advert property can only contain items of \QCC\CampusM\CloudService\StructType\Advert, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->advert[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Adverts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
