<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addFriendRequest StructType
 * @subpackage Structs
 */
class AddFriendRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The friendPersonId
     * @var int
     */
    public $friendPersonId;
    /**
     * The order
     * @var int
     */
    public $order;
    /**
     * The groupDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $groupDescription;
    /**
     * Constructor method for addFriendRequest
     * @uses AddFriendRequest::setPersonId()
     * @uses AddFriendRequest::setPassword()
     * @uses AddFriendRequest::setFriendPersonId()
     * @uses AddFriendRequest::setOrder()
     * @uses AddFriendRequest::setGroupDescription()
     * @param int $personId
     * @param string $password
     * @param int $friendPersonId
     * @param int $order
     * @param string $groupDescription
     */
    public function __construct($personId = null, $password = null, $friendPersonId = null, $order = null, $groupDescription = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setFriendPersonId($friendPersonId)
            ->setOrder($order)
            ->setGroupDescription($groupDescription);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\AddFriendRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\AddFriendRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get friendPersonId value
     * @return int|null
     */
    public function getFriendPersonId()
    {
        return $this->friendPersonId;
    }
    /**
     * Set friendPersonId value
     * @param int $friendPersonId
     * @return \QCC\CampusM\CloudService\StructType\AddFriendRequest
     */
    public function setFriendPersonId($friendPersonId = null)
    {
        // validation for constraint: int
        if (!is_null($friendPersonId) && !is_numeric($friendPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($friendPersonId)), __LINE__);
        }
        $this->friendPersonId = $friendPersonId;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \QCC\CampusM\CloudService\StructType\AddFriendRequest
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get groupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupDescription()
    {
        return isset($this->groupDescription) ? $this->groupDescription : null;
    }
    /**
     * Set groupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupDescription
     * @return \QCC\CampusM\CloudService\StructType\AddFriendRequest
     */
    public function setGroupDescription($groupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($groupDescription) && !is_string($groupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupDescription)), __LINE__);
        }
        if (is_null($groupDescription) || (is_array($groupDescription) && empty($groupDescription))) {
            unset($this->groupDescription);
        } else {
            $this->groupDescription = $groupDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AddFriendRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
