<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listAvailableFeeds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\ListAvailableFeedsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableFeedsResponse|bool
     */
    public function listAvailableFeeds(\QCC\CampusM\CloudService\StructType\ListAvailableFeedsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->listAvailableFeeds($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAvailableProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableProfilesResponse|bool
     */
    public function listAvailableProfiles(\QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->listAvailableProfiles($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAvailableOrganisations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsResponse|bool
     */
    public function listAvailableOrganisations(\QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->listAvailableOrganisations($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listQuestions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\ListQuestions $payload
     * @return \QCC\CampusM\CloudService\StructType\ListQuestionsResponse|bool
     */
    public function listQuestions(\QCC\CampusM\CloudService\StructType\ListQuestions $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->listQuestions($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoteCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\ListVoteCategories $payload
     * @return \QCC\CampusM\CloudService\StructType\ListVoteCategoriesResponse|bool
     */
    public function listVoteCategories(\QCC\CampusM\CloudService\StructType\ListVoteCategories $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoteCategories($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableFeedsResponse|\QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsResponse|\QCC\CampusM\CloudService\StructType\ListAvailableProfilesResponse|\QCC\CampusM\CloudService\StructType\ListQuestionsResponse|\QCC\CampusM\CloudService\StructType\ListVoteCategoriesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
