<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ucisa ServiceType
 * @subpackage Services
 */
class Ucisa extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ucisaThingy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UcisaThingyRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\UcisaThingyResponse|bool
     */
    public function ucisaThingy(\QCC\CampusM\CloudService\StructType\UcisaThingyRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->ucisaThingy($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\UcisaThingyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
