<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named submitQuestion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SubmitQuestion $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function submitQuestion(\QCC\CampusM\CloudService\StructType\SubmitQuestion $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->submitQuestion($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named submitUserFeedback
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SubmitUserFeedback $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function submitUserFeedback(\QCC\CampusM\CloudService\StructType\SubmitUserFeedback $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->submitUserFeedback($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named submitUserIdea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SubmitUserIdea $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function submitUserIdea(\QCC\CampusM\CloudService\StructType\SubmitUserIdea $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->submitUserIdea($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named submitUserProblem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SubmitUserProblem $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function submitUserProblem(\QCC\CampusM\CloudService\StructType\SubmitUserProblem $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->submitUserProblem($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named submitIdea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SubmitIdea $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function submitIdea(\QCC\CampusM\CloudService\StructType\SubmitIdea $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->submitIdea($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named submitProblem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SubmitProblem $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function submitProblem(\QCC\CampusM\CloudService\StructType\SubmitProblem $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->submitProblem($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
