<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Splash ServiceType
 * @subpackage Services
 */
class Splash extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named splashPage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SplashPage $payload
     * @return \QCC\CampusM\CloudService\StructType\SplashPageResponse|bool
     */
    public function splashPage(\QCC\CampusM\CloudService\StructType\SplashPage $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->splashPage($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\SplashPageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
