<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Southampton ServiceType
 * @subpackage Services
 */
class Southampton extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named southamptonPositions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdatePositions $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function southamptonPositions(\QCC\CampusM\CloudService\StructType\UpdatePositions $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->southamptonPositions($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
