<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named retrieveRssHeaderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\RetrieveRssHeaderItemsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\RetrieveRssHeaderItemsResponse|bool
     */
    public function retrieveRssHeaderItems(\QCC\CampusM\CloudService\StructType\RetrieveRssHeaderItemsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->retrieveRssHeaderItems($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveAlertSubscriptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\RetrieveAlertSubscriptionsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\RetrieveAlertSubscriptionsResponse|bool
     */
    public function retrieveAlertSubscriptions(\QCC\CampusM\CloudService\StructType\RetrieveAlertSubscriptionsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->retrieveAlertSubscriptions($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveFavourites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\RetrieveFavouritesRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\RetrieveFavouritesResponse|bool
     */
    public function retrieveFavourites(\QCC\CampusM\CloudService\StructType\RetrieveFavouritesRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->retrieveFavourites($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrievePosition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\RetrievePosition $payload
     * @return \QCC\CampusM\CloudService\StructType\RetrievePositionResponse|bool
     */
    public function retrievePosition(\QCC\CampusM\CloudService\StructType\RetrievePosition $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->retrievePosition($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\RetrieveAlertSubscriptionsResponse|\QCC\CampusM\CloudService\StructType\RetrieveFavouritesResponse|\QCC\CampusM\CloudService\StructType\RetrievePositionResponse|\QCC\CampusM\CloudService\StructType\RetrieveRssHeaderItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
