<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Result ServiceType
 * @subpackage Services
 */
class Result extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resultUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\VoteResultUrlRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\VoteResultUrlResponse|bool
     */
    public function resultUrl(\QCC\CampusM\CloudService\StructType\VoteResultUrlRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->resultUrl($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\VoteResultUrlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
